from dotenv import load_dotenv

load_dotenv()
from intentservice import IntentService
from responseservice import ResponseService
from dataservice import DataService

# Przykładowy plik pdf
pdf = 'pliki/ExplorersGuide.pdf'

data_service = DataService()

# W razie konieczności zrzucenie wszystkich danych z Redis
data_service.drop_redis_data()

# Wczytanie danych z pliku pdf do Redis
data = data_service.pdf_to_embeddings(pdf)

data_service.load_data_to_redis(data)

intent_service = IntentService()
response_service = ResponseService()

# Pytanie 
question = 'Gdzie znaleźć skrzynie ze skarbami?'
# Odczytanie zamiaru
intents = intent_service.get_intent(question)
# Uzyskanie faktów
facts = data_service.search_redis(intents)
# Uzyskanie odpowiedzi
answer = response_service.generate_response(facts, question)
print(answer)
